using System;
using System.ComponentModel;
using System.Collections;
using System.Diagnostics;
using gov.va.med.vbecs;
using gov.va.med.vbecs.Common;
using System.Text.RegularExpressions;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI.controls
{


	#region Header

	///<Package>Package: VBECS - VistA Blood Establishment Computer System</Package>
	///<Warning> WARNING: Per VHA Directive $VADIRECTIVE this class should not be modified</Warning>
	///<MedicalDevice> Medical Device #: $MEDDEVICENO</MedicalDevice>
	///<Developers>
	///	<Developer>Cameron Taylor</Developer>
	///</Developers>
	///<SiteName>Hines OIFO</SiteName>
	///<CreationDate>9/4/2002</CreationDate>
	///<Note>The Food and Drug Administration classifies this software as a medical device.  As such, it may not be changed in any way. Modifications to this software may result in an adulterated medical device under 21CFR820, the use of which is considered to be a violation of US Federal Statutes.  Acquiring and implementing this software through the Freedom of information Act requires the implementor to assume total responsibility for the software, and become a registered manufacturer of a medical device, subject to FDA regulations</Note>
	///<summary>
	///Extended BarcodeTextbox control with additional BarcodeType property, for Unit ID entry.
	///</summary>

	#endregion


	public class UnitIDTextbox : gov.va.med.vbecs.GUI.controls.BarcodeTextbox
	{
		/// <summary>
		/// Determines if product code is ISBT-128 or Codabar.
		/// </summary>
		private BarcodeType barcodeType = BarcodeType.None;

		/// <summary>
		/// ISBTScan object
		/// </summary>
		public Common.ISBTScan isbtScan = Common.ISBTScan.Unknown;

		private bool _Valid = true;
		private int _maxLength = 15;

		/// <summary>
		/// Raises event if a barcode is scanned into this text box that is not a Unit ID.
		/// </summary>
		public event EventHandler OtherIsbtFieldScanned;
		
		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>11/4/2002</CreationDate>
		/// <summary>
		/// BarcodeTypeChanged EventHandler
		/// </summary>
		public event EventHandler BarcodeTypeChanged;

		/// <summary>
		/// Raises barcode type changed event
		/// </summary>
		protected virtual void OnBarcodeTypeChanged()
		{
			if(BarcodeTypeChanged != null)
				BarcodeTypeChanged(this, EventArgs.Empty);
		}

		/// <summary>
		/// Raises event if a barcode is scanned into this text box
		/// that is not a unit id.
		/// </summary>
		protected virtual void OnOtherIsbtFieldScanned()
		{
			if(OtherIsbtFieldScanned != null)
				OtherIsbtFieldScanned(this, EventArgs.Empty);
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/17/2002</CreationDate>
		/// <summary>
		/// UnitIDTextbox control class constructor.
		/// </summary>
		public UnitIDTextbox()
		{
			InitializeComponent();
			//
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/17/2002</CreationDate>
		///
		/// <summary>
		/// UnitIDTextbox control class constructor.
		/// </summary>
		/// <param name="container">IContainer</param>
		public UnitIDTextbox(System.ComponentModel.IContainer container)
		{
			container.Add(this);
			InitializeComponent();
			//
		}

		#region Component Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			components = new System.ComponentModel.Container();
			//CR 2128
			this.MaxLength = 15;
		}
		#endregion

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>9/4/2002</CreationDate>
		/// <summary>
		/// Barcode Type property. Returns BarcodeType enum of blood product code entered.
		/// </summary>
		[
		Category("Behavior"),
		Description("Barcode Type"),
		Bindable(true),
		Browsable(true),
		]
		public new BarcodeType BarcodeType
		{
			get
			{
				return barcodeType; 
			}
			set
			{
				barcodeType = value;
				OnBarcodeTypeChanged();
			}
		}
		///<Developers>
		///	<Developer>Carrie Van Stedumr</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>12/30/2006</CreationDate>
		/// <summary>
		/// max length of text box
		/// </summary>
		[
		Category("Behavior"),
		Description("Max Length"),
		Bindable(true),
		Browsable(true),
		]
		public override sealed int MaxLength
		{
			get
			{
				//return maxLength;
				return this._maxLength;
			}
			set
			{
				//CR 2128
				//A unit ID's max length must always be 15
				if(base.MaxLength != 15)
				{
					this._maxLength = 15;
					base.MaxLength = 15;
				}
			}
		}

		/// <summary>
		/// UnitIDValid
		/// </summary>
		public bool UnitIDValid
		{
			get
			{
				return this._Valid;
			}
		}

		///<Developers>
		///	<Developer>Cameron Taylor</Developer>
		///</Developers>
		///<SiteName>Hines OIFO</SiteName>
		///<CreationDate>10/13/2002</CreationDate>
		/// <summary>
		/// Override for Leave event to determine format of unit id entered. 
		/// Implements BR_1.04
		/// </summary>
		/// <param name="e"></param>
		protected override void OnLeave(EventArgs e)
		{
			Regex _regexCodabar = Common.RegularExpressions.CodabarUnitID();
			Regex _regexISBT128 = Common.RegularExpressions.ScannedISBT128UnitID();
			isbtScan = Common.Utility.GetISBTFromString(this.Text);
			this._Valid = true;
			//
			string _txt = string.Empty;
			int nLen = this.Text.Length - 1;

			if(nLen > 0)
			{
				_txt = this.Text.Substring(0, nLen).ToUpper() + this.Text.Substring(nLen,1);
			}
			
			//BR_1.14
			if (_regexISBT128.IsMatch(_txt))
			{
				if (_regexISBT128.IsMatch(_txt))
				{
					if (_txt.Substring(0,1).Equals("="))
					{
						this.Barcode = true;
					}

				}
				this.BarcodeType = BarcodeType.ISBT128;
				_txt = _txt.Replace("=","");
				if (_txt.Length>13)
				{
					_txt = _txt.Substring(0,13);
				}
			}
				//BR_1.13
			else if (_regexCodabar.IsMatch(_txt))
			{
				this.BarcodeType = BarcodeType.Codabar;
			}
			else
			{
				this.BarcodeType = BarcodeType.None;
			}
			//
			this.Text = _txt;

			// If an ISBT field other than product code is scanned
			if (isbtScan != Common.ISBTScan.UnitId && isbtScan != Common.ISBTScan.Unknown)
			{
				_Valid = false;
				OnOtherIsbtFieldScanned();			
			}

			base.OnLeave(e);
		}
		
		/// <summary>
		/// This is used to set the text of a control from another control.  It is used when
		/// an ISBT field is scanned into the wrong text box.  That control passes the text to 
		/// correct control and reset it with this code.
		/// </summary>
		public void SetControl()
		{
			Regex _regexCodabar = Common.RegularExpressions.CodabarUnitID();
			Regex _regexISBT128 = Common.RegularExpressions.ISBT128UnitID();
			//
			string _txt = string.Empty;
			int nLen = this.Text.Length - 1;

			if(nLen > 0)
			{
				_txt = this.Text.Substring(0, nLen).ToUpper() + this.Text.Substring(nLen,1);
			}
			
			//BR_1.14
			if (_regexISBT128.IsMatch(_txt))
			{
			
				if (_txt.Substring(0,1).Equals("="))
				{
					this.Barcode = true;
				}
				
				this.BarcodeType = BarcodeType.ISBT128;
				_txt = _txt.Replace("=","");
				if (_txt.Length>13)
				{
					_txt = _txt.Substring(0,13);
				}
			}
				//BR_1.13
			else if (_regexCodabar.IsMatch(_txt))
			{
				this.BarcodeType = BarcodeType.Codabar;
			}
			else
			{
				this.BarcodeType = BarcodeType.None;
			}
			//
			this.Text = _txt;
			//base.OnLeave(e);
		}

	}
}

